/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.input.ShortcutInput;
import de.willuhn.jameica.gui.internal.parts.SearchPart;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.services.SearchService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableItem;

public class SearchOptionsDialog
extends AbstractDialog {
    public SearchOptionsDialog(int position) {
        super(position);
        this.setTitle(Application.getI18n().tr("Such-Optionen"));
        this.setSize(400, 380);
    }

    protected Object getData() throws Exception {
        return null;
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        final I18N i18n = Application.getI18n();
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addText(i18n.tr("Bitte w\u00e4hlen Sie die Themen, in denen gesucht werden soll:"), true);
        final SearchPart searchPart = GUI.getView().getSearchPart();
        final ShortcutInput shortcut = new ShortcutInput(searchPart.getShortcut());
        shortcut.setName(Application.getI18n().tr("Tastenk\u00fcrzel f\u00fcr das Eingabefeld"));
        container.addInput(shortcut);
        final SearchService service = (SearchService)Application.getBootLoader().getBootable(SearchService.class);
        final SearchProvider[] providers = service.getSearchProviders();
        HashMap<String, ArrayList<ProviderObject>> plugins = new HashMap<String, ArrayList<ProviderObject>>();
        for (int i = 0; i < providers.length; ++i) {
            ProviderObject o = new ProviderObject(providers[i]);
            String name = (String)o.getAttribute("plugin");
            ArrayList<ProviderObject> l = (ArrayList<ProviderObject>)plugins.get(name);
            if (l == null) {
                l = new ArrayList<ProviderObject>();
                plugins.put(name, l);
            }
            l.add(o);
        }
        ArrayList list = new ArrayList();
        Iterator it = plugins.values().iterator();
        while (it.hasNext()) {
            list.addAll((Collection)it.next());
        }
        final TablePart table = new TablePart(list, null);
        table.addColumn(i18n.tr("Bezeichnung"), "name");
        table.setCheckable(true);
        table.setMulti(false);
        table.removeFeature(FeatureSummary.class);
        table.setRememberColWidths(true);
        table.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                ProviderObject o = (ProviderObject)item.getData();
                item.setChecked(service.isEnabled(o.provider));
            }
        });
        container.addPart(table);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    KeyStroke ks;
                    for (int i = 0; i < providers.length; ++i) {
                        service.setEnabled(providers[i], false);
                    }
                    List selected = table.getItems();
                    if (selected != null) {
                        for (int i = 0; i < selected.size(); ++i) {
                            ProviderObject o = (ProviderObject)selected.get(i);
                            service.setEnabled(o.provider, true);
                        }
                    }
                    searchPart.setShortcut((ks = (KeyStroke)shortcut.getValue()) != null ? ks.format() : null);
                }
                catch (Exception e) {
                    Logger.error((String)"error while applying options", (Throwable)e);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim \u00dcbernehmen der Einstellungen"), 1));
                }
                Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Einstellungen gespeichert"), 0));
                SearchOptionsDialog.this.close();
            }
        }, null, true, "ok.png");
        buttons.addButton(i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                SearchOptionsDialog.this.close();
            }
        }, null, false, "process-stop.png");
        container.addButtonArea(buttons);
    }

    private class ProviderObject
    implements GenericObject {
        private SearchProvider provider = null;

        private ProviderObject(SearchProvider provider) {
            this.provider = provider;
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || !(other instanceof ProviderObject)) {
                return false;
            }
            return this.getID().equals(other.getID());
        }

        public Object getAttribute(String name) throws RemoteException {
            String plugin;
            Plugin p = Application.getPluginLoader().findByClass(this.provider.getClass());
            String string = plugin = p == null ? "Jameica" : p.getManifest().getName();
            if ("plugin".equals(name)) {
                return plugin;
            }
            return plugin + ": " + this.provider.getName();
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"plugin", "name"};
        }

        public String getID() throws RemoteException {
            return this.provider.getClass().getName();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "name";
        }
    }
}

